//------------------------------------------------------------------------------
// File: client_tasksvrcmds.cs
// This file contains server command methods for the task system
// Author: Matthew Rudge
//------------------------------------------------------------------------------

////////////////////////////////////////////////////////////////////////////////
//! Sets the gui visibility
//! \param %param Contains gui name and visibility
////////////////////////////////////////////////////////////////////////////////
function clientCmdSetGuiVisibility(%param)
{
   // Get gui name
   %gui = getWord(%param, 0);
   if(!isObject(%gui)) {
      return;
   }
   
   // Get visibility
   %visible = getWord(%param, 1);
   
   // Switch visibility
   %gui.Visible = %visible;
}

////////////////////////////////////////////////////////////////////////////////
//! Server command to enable/disable a command button
//! \param %param Contains command to enable/disable and boolean
////////////////////////////////////////////////////////////////////////////////
function clientCmdEnableCommand(%param)
{
   // Get variables
   %cmd    = getWord(%param, 0);
   %enable = getWord(%param, 1);
   
   if(%enable) {
      csEnableCommand(%cmd);
   }
   else {
      csDisableCommand(%cmd);
   }
}

////////////////////////////////////////////////////////////////////////////////
//! Command to blink a button
//! \param %param Contains the button name, time, count, start color, and peek
//! color
////////////////////////////////////////////////////////////////////////////////
function clientCmdBlinkButton(%param)
{
   // Get params
   %btn        = getWord(%param, 0);
   %timeUp     = getWord(%param, 1);
   %timeFocus  = getWord(%param, 2);
   %count      = getWord(%param, 3);
   
   // Blink button
   %startcolor = "1 1 1 1";
   %peekcolor  = "0 0 0 0";
   NotifyBlink(%btn, %timeUp, %timeFocus, %count);
   //%btn.Blink(%time, %count, %startcolor, %peekcolor);
}

////////////////////////////////////////////////////////////////////////////////
//! Enables/disables input
//! \param %enable True to enable, false to disable
////////////////////////////////////////////////////////////////////////////////
function clientCmdEnableInput(%enable)
{
   $Input::WindowScroll = %enable;
   if(%enable) {
      Canvas.popDialog(DisableGui);
   }
   else {
      Canvas.pushDialog(DisableGui);
   }
}

////////////////////////////////////////////////////////////////////////////////
//! Shows/hides dialog guis
//! \param %param Contains the dialog name and the boolean to show/hide
////////////////////////////////////////////////////////////////////////////////
function clientCmdShowDialog(%param)
{
   // Get params
   %dlg  = getWord(%param, 0);
   %show = getWord(%param, 1);
   
   // Show/hide
   if(%show) {
      Canvas.pushDialog(%dlg);
   }
   else {
      Canvas.popDialog(%dlg);
   }
}

////////////////////////////////////////////////////////////////////////////////
//! Adds/Removes quests in quest hud
//! \param %quest Quest name
//! \param %add True to add, false to remove
////////////////////////////////////////////////////////////////////////////////
function clientCmdModifyQuestInQuestHud(%quest, %add)
{
   if(%add) {
      AddQuest(%quest);
   }
   else {
      RemoveQuest(%quest);
   }
}

////////////////////////////////////////////////////////////////////////////////
//! Adds/Removes/Checks quest tasks in quest hud
//! \param %quest Quest name
//! \param %task Task text
//! \param %mod "add", "rem", or "chk"
////////////////////////////////////////////////////////////////////////////////
function clientCmdModifyTaskInQuestHud(%quest, %task, %mod)
{
   // Add task
   if(%mod $= "add") {
      AddQuestTask(%quest, %task);
   }
   
   // Check task
   else if(%mod $= "chk") {
      CheckQuestTask(%quest, %task);
   }
   
   // Remove task
   else if(%mod $= "rem") {
      RemoveQuestTask(%quest, %task);
   }
}

////////////////////////////////////////////////////////////////////////////////
//! Places a message in the alert hud
//! \param %msg Message to place
////////////////////////////////////////////////////////////////////////////////
function clientCmdSendAlertMessage(%msg)
{
   alertPushMsg(%msg);
}

////////////////////////////////////////////////////////////////////////////////
//! Places a message in the alert hud from the message id
//! \param %msgId Message id of message to place
////////////////////////////////////////////////////////////////////////////////
function clientCmdSendAlertMessageId(%msgId)
{
   alertPushMsg(slgGetUIString(%msgId));
}

////////////////////////////////////////////////////////////////////////////////
//! Notifies a client that its mesh has changed status. This method is used
//! to reenable collision on the client for an object that may start out as
//! disabled if object is initialized with showMesh set to false
//! \param %param Contains the ghost and boolean for showing
////////////////////////////////////////////////////////////////////////////////
function clientCmdOnMeshChange(%param)
{
   %ghost = getWord(%param, 0);
   %show  = getWord(%param, 1);
   
   %obj = ServerConnection.resolveGhost(%ghost);
   
   if(%show) {
      %obj.enableCollision();
   }
   else {
      %obj.disableCollision();
   }
}

////////////////////////////////////////////////////////////////////////////////
//! Notifies a client when a badge has been awarded
//! \param %msg Message for alert hud
////////////////////////////////////////////////////////////////////////////////
function clientCmdOnBadgeAward(%msg)
{
   // Push message in alert hud
   alertPushMsg(%msg);
   
   // Play sound
   playSFXSound("audio_awardbadge");
}

////////////////////////////////////////////////////////////////////////////////
//! Notifies a client when a experience has been awarded
////////////////////////////////////////////////////////////////////////////////
function clientCmdOnXpAward()
{
   // Play sound
   playSFXSound("audio_awardxp");
}

// End client_tasksvrcmds.cs